/*  Title: User account information
    Author: Gabriele Santilli

    This table stores the user account information for ShowBizCentral.

    Please do not query directly, but use the sprocs.
 */

CREATE TABLE users (
    user_id     INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
    created_on  DATETIME NOT NULL,
    modified_on DATETIME NOT NULL,
    iterations  MEDIUMINT UNSIGNED NOT NULL,
    salt        BINARY(32) NOT NULL,
    hash        BINARY(32) NOT NULL,
    email       VARCHAR(255) NOT NULL,
    `data`      TEXT NOT NULL,

    UNIQUE KEY (email)
) ENGINE=InnoDB;

CREATE TABLE users_archive (
    user_id     INT UNSIGNED NOT NULL,
    modified_on DATETIME NOT NULL,
    archived_on DATETIME NOT NULL,
    `data`      TEXT NOT NULL
) ENGINE=InnoDB;
