/*  Title: ShowBizCentral Users API
    Author: Gabriele Santilli

    create_user        - create a new user (signup)
    read_user          - read user account info
    read_user_by_email - read user account info (login)
    edit_user          - edit user account info
    delete_user        - delete user account (not sure if we want to allow it)
 */

DELIMITER $$

DROP PROCEDURE IF EXISTS create_user $$
CREATE PROCEDURE create_user ( IN Pemail      VARCHAR(255), 
                               IN Piterations MEDIUMINT UNSIGNED,
                               IN Psalt       BINARY(32),
                               IN Phash       BINARY(32),
                               IN Pdata       TEXT )
    BEGIN
        DECLARE Vnow DATETIME;

        SET Vnow = NOW();

        INSERT INTO users (created_on, modified_on, iterations,  salt,  hash,  email,  `data`)
                   VALUES (Vnow,       Vnow,        Piterations, Psalt, Phash, Pemail, Pdata);

        SELECT LAST_INSERT_ID() user_id,
               Vnow             created_on;
    END;
$$

DROP PROCEDURE IF EXISTS read_user $$
CREATE PROCEDURE read_user ( IN Puser_id INT UNSIGNED )
    BEGIN
        SELECT user_id,
               email,
               created_on,
               modified_on,
               `data`
          FROM users
         WHERE user_id = Puser_id;
    END;
$$

DROP PROCEDURE IF EXISTS read_user_by_email $$
CREATE PROCEDURE read_user_by_email ( IN Pemail VARCHAR(255) )
    BEGIN
        SELECT user_id,
               email,
               created_on,
               modified_on,
               `data`,
               iterations,
               salt,
               hash
          FROM users
         WHERE email = Pemail;
    END;
$$

DROP PROCEDURE IF EXISTS edit_user $$
CREATE PROCEDURE edit_user ( IN Puser_id    INT UNSIGNED,
                             IN Pemail      VARCHAR(255), -- can be NULL (no change)
                             IN Piterations MEDIUMINT UNSIGNED, -- +
                             IN Psalt       BINARY(32),         -- +-- can be NULL (no change)
                             IN Phash       BINARY(32),         -- +
                             IN Pdata       TEXT ) -- can be NULL (no change)
    BEGIN
        DECLARE Vnow DATETIME;

        SET Vnow = NOW();

        START TRANSACTION;

        IF Pemail IS NOT NULL THEN
            UPDATE users
               SET email       = Pemail,
                   modified_on = Vnow
             WHERE user_id     = Puser_id;
        END IF;

        IF (Piterations IS NOT NULL) AND (Psalt IS NOT NULL) AND (Phash IS NOT NULL) THEN
            UPDATE users
               SET iterations  = Piterations,
                   salt        = Psalt,
                   hash        = Phash,
                   modified_on = Vnow
             WHERE user_id     = Puser_id;
        END IF;

        IF Pdata IS NOT NULL THEN
            INSERT INTO users_archive (user_id, modified_on, archived_on, `data`)
                        SELECT user_id,
                               modified_on,
                               Vnow,
                               `data`
                          FROM users
                         WHERE user_id = Puser_id;
            UPDATE users
               SET `data`      = Pdata,
                   modified_on = Vnow
             WHERE user_id     = Puser_id;
        END IF;

        COMMIT;
    END;
$$

DROP PROCEDURE IF EXISTS delete_user $$
CREATE PROCEDURE delete_user ( IN Puser_id INT UNSIGNED )
    BEGIN
        -- ?
    END;
$$

DELIMITER ;
