/*  Title: ShowBizCentral Portfolios API
    Author: Gabriele Santilli

    list_user_portfolios - list portfolios owned by given user
    create_portfolio     - create a new portfolio
    read_portfolio       - read portfolio data
    read_portfolio_owner - read portfolio's owner
    edit_portfolio       - edit portfolio data
    delete_portfolio     - delete portfolio
 */

DELIMITER $$

DROP PROCEDURE IF EXISTS list_user_portfolios $$
CREATE PROCEDURE list_user_portfolios ( IN Powner INT UNSIGNED )
    BEGIN
        SELECT   portfolio_id,
                 owner,
                 created_on,
                 modified_on,
                 `data`
            FROM portfolios
           WHERE owner = Powner
        ORDER BY created_on;
    END;
$$

DROP PROCEDURE IF EXISTS create_portfolio $$
CREATE PROCEDURE create_portfolio ( IN Powner INT UNSIGNED,
                                    IN Pdata  TEXT )
    BEGIN
        DECLARE Vnow DATETIME;

        SET Vnow = NOW();

        INSERT INTO portfolios (owner,  created_on, modified_on, `data`)
                        VALUES (Powner, Vnow,       Vnow,        Pdata);

        SELECT LAST_INSERT_ID() portfolio_id,
               Vnow             created_on;
    END;
$$

DROP PROCEDURE IF EXISTS read_portfolio $$
CREATE PROCEDURE read_portfolio ( IN Pportfolio_id INT UNSIGNED )
    BEGIN
        SELECT portfolio_id,
               owner,
               created_on,
               modified_on,
               `data`
          FROM portfolios
         WHERE portfolio_id = Pportfolio_id;
    END;
$$

DROP PROCEDURE IF EXISTS read_portfolio_owner $$
CREATE PROCEDURE read_portfolio_owner ( IN Pportfolio_id INT UNSIGNED )
    BEGIN
        SELECT owner
          FROM portfolios
         WHERE portfolio_id = Pportfolio_id;
    END;
$$

DROP PROCEDURE IF EXISTS edit_portfolio $$
CREATE PROCEDURE edit_portfolio ( IN Pportfolio_id INT UNSIGNED,
                                  IN Powner        INT UNSIGNED, -- cannot be changed
                                  IN Pdata         TEXT )
    BEGIN
        DECLARE Vnow DATETIME;

        SET Vnow = NOW();

        START TRANSACTION;

        INSERT INTO portfolios_archive (portfolio_id, modified_on, archived_on, `data`)
                    SELECT portfolio_id,
                           modified_on,
                           Vnow,
                           `data`
                      FROM portfolios
                     WHERE portfolio_id = Pportfolio_id
                       AND owner        = Powner;
        UPDATE portfolios
           SET modified_on = Vnow,
               `data`      = Pdata
         WHERE portfolio_id  = Pportfolio_id
           AND owner         = Powner;

        COMMIT;
    END;
$$

DROP PROCEDURE IF EXISTS delete_portfolio $$
CREATE PROCEDURE delete_portfolio ( IN Pportfolio_id INT UNSIGNED,
                                    IN Powner        INT UNSIGNED )
    BEGIN
        DECLARE Vnow DATETIME;

        SET Vnow = NOW();

        START TRANSACTION;

        INSERT INTO portfolios_archive (portfolio_id, modified_on, archived_on, `data`)
                    SELECT portfolio_id,
                           modified_on,
                           Vnow,
                           `data`
                      FROM portfolios
                     WHERE portfolio_id = Pportfolio_id
                       AND owner        = Powner;
        DELETE FROM portfolios
              WHERE portfolio_id = Pportfolio_id
                AND owner        = Powner;

        COMMIT;
    END;
$$

DELIMITER ;
