var Template = require('./Template').Template,
    fs = require('./fs-promises'),
    SpecialPage = require('./SpecialPage').SpecialPage,
    path = require('path');


exports.generateSpecialPages = function (config) {
    var template = new Template(config.templateDir, config.templateVariables);
    for (var i = 0; i < config.specialPages.length; i++) {
        var page = config.specialPages[i],
            html = template.generate(new SpecialPage(page));

        fs.writeFile(path.join(config.pagesDir, page.name), html, 'utf-8');
    }
}
