/*                     PROLIFIC CONTENT MANAGEMENT SYSTEM
===============================================================================
                              by Gabriele Santilli
              (C) 2012 Silent Software, Inc. All rights reserved.

                                                                             */
var define = require('prolific/utils').define,
    fs = require('fs'),
    cheerio = require('cheerio'),
    Promise = require('prolific/Promise').Promise,
    promisify = require('prolific/Promise').promisify,
    path = require('path');

function readIfExists(filename, def) {
    try {
        return fs.readFileSync(filename, 'utf-8');
    } catch (error) {
        if (error.code == 'ENOENT') return def;
        else throw error;
    }
}

function replaceVariables(string, variables) {
    for (var name in variables) {
        string = string.replace(new RegExp('\\$' + name + '\\$', 'g'), variables[name]);
    }
    return string;
}

exports.Template = define({
    constructor: function (dir, variables) {
        this.variables = variables;

        try {
            this.html = fs.readFileSync(path.join(dir, 'html'), 'utf-8');
        } catch (error) {
            if (error.code == 'ENOENT') throw new Error('Invalid template directory: ' + dir);
            else throw error;
        }
        this.css = readIfExists(path.join(dir, 'css'), false);
        this.js = readIfExists(path.join(dir, 'js'), false);

        this.html = replaceVariables(this.html, variables);
    },
    generate: function (content) {
        var $ = cheerio.load(this.html);
        if (this.css)
            $('head').append('<style>\n' + this.css + '\n</style>');
        if (this.js)
            $('head').append('<script>\n' + this.js + '\n</script>');

        if (typeof content == 'string') {
            $('#content').html(content);
        } else {
            if (content.content)
                $('#content').html(replaceVariables(content.content, this.variables));
            if (content.head)
                $('head').append(replaceVariables(content.head, this.variables));
            if (content.css)
                $('head').append('<style>\n' + content.css + '\n</style>');
            if (content.js) {
                $('head').append('<script>\n' + content.js + '\n</script>');
            }
            if (content.process)
                content.process(this.variables, $);
        }
        return $.html();
    }
});
