/*                     PROLIFIC CONTENT MANAGEMENT SYSTEM
===============================================================================
                              by Gabriele Santilli
              (C) 2012 Silent Software, Inc. All rights reserved.

                                                                             */
var define = require('prolific/utils').define,
    fs = require('fs'),
    path = require('path');

function exists(filename) {
    try {
        fs.statSync(filename);
        return true;
    } catch (error) {
        if (error.code == 'ENOENT') return false;
        else throw error;
    }
}

function readIfExists(filename, def) {
    try {
        return fs.readFileSync(filename, 'utf-8');
    } catch (error) {
        if (error.code == 'ENOENT') return def;
        else throw error;
    }
}

exports.SpecialPage = define({
    constructor: function (spec) {
        this.name = spec.name;
        this.config = spec.config;
        this.content = readIfExists(path.join(spec.moduleDir, 'content'), false);
        this.css = readIfExists(path.join(spec.moduleDir, 'css'), false);
        this.js = readIfExists(path.join(spec.moduleDir, 'js'), false);
        this.head = readIfExists(path.join(spec.moduleDir, 'head'), false);
        var processModule = path.join(spec.moduleDir, 'process.js');
        if (exists(processModule)) {
            this.processModule = require(processModule);
        }
    },
    process: function (variables, $) {
        if (this.processModule) this.processModule.process(this.config, variables, $);
    }
});
