/*                  TESTS FOR THE PROLIFIC UTILITIES MODULE
===============================================================================
                              by Gabriele Santilli
              (C) 2012 Silent Software, Inc. All rights reserved.

This program tests the "define()" function. See [The_define_function].
                                                                             */
var test = require('./test'),
    define = require('./utils').define,
    Object1 = define({
        set: function(value) {this.value = value; return value;},
        get: function() {return this.value;}
    }),
    Object2 = define({
        constructor: function(value) {this.value = value;},
        set: function(value) {this.value = value; return value;},
        get: function() {return this.value;}
    }),
    Object3 = define({
        inherit: Object2,
        add: function(value) {return this.value + value;}
    }),
    Object4 = define({
        inherit: Object2,
        manualSuper: true,
        constructor: function(x, y) {
            Object2.call(this, x + y);
        }
    });

test.begin('Prolific utilities module');

test.isFunction(define, 'define');
test.throws(define, 'AssertionError', 'define');
test.throws(function() {define(42);}, 'AssertionError', 'define(42)');
test.isFunction(define({}), 'result of define({})');
test.throws(function() {define({constructor: 42});}, 'AssertionError', 'define({constructor: 42})');
test.isFunction(define({
    constructor: function() {this.value = 42;}
}), 'result of define({constructor: ...})');
test.throws(function() {define({inherit: 42});}, 'AssertionError', 'define({inherit: 42})');
test.isFunction(define({
    inherit: function() {this.value = 42;}
}), 'result of define({inherit: ...})');

test.isFunction(Object1, 'Object1');
var obj1 = new Object1;
test.isObject(obj1, 'obj1');
test.instanceOf(obj1, Object1, 'obj1 instanceof Object1');
test.isFunction(obj1.set, 'obj1.set');
test.isFunction(obj1.get, 'obj1.get');
test.isEqual(obj1.set(42), 42, 'obj1.set(42) == 42');
test.isEqual(obj1.get(), 42, 'obj1.get() == 42');

test.isFunction(Object2, 'Object2');
var obj2 = new Object2(10);
test.isObject(obj2, 'obj2');
test.instanceOf(obj2, Object2, 'obj2 instanceof Object2');
test.isFunction(obj2.set, 'obj2.set');
test.isFunction(obj2.get, 'obj2.get');
test.isEqual(obj2.get(), 10, 'obj2.get() == 10 (initial)');
test.isEqual(obj2.set(42), 42, 'obj2.set(42) == 42');
test.isEqual(obj2.get(), 42, 'obj2.get() == 42 (after set)');

test.isFunction(Object3, 'Object2');
var obj3 = new Object3(10);
test.isObject(obj3, 'obj3');
test.instanceOf(obj3, Object3, 'obj3 instanceof Object3');
test.instanceOf(obj3, Object2, 'obj3 instanceof Object2');
test.isFunction(obj3.set, 'obj3.set');
test.isFunction(obj3.get, 'obj3.get');
test.isFunction(obj3.add, 'obj3.add');
test.isEqual(obj3.get(), 10, 'obj3.get() == 10 (initial)');
test.isEqual(obj3.set(42), 42, 'obj3.set(42) == 42');
test.isEqual(obj3.get(), 42, 'obj3.get() == 42 (after set)');
test.isEqual(obj3.add(10), 52, 'obj3.add(10) == 52');

test.isFunction(Object4, 'Object4');
var obj4 = new Object4(4, 6);
test.isObject(obj4, 'obj4');
test.instanceOf(obj4, Object4, 'obj4 instanceof Object4');
test.instanceOf(obj4, Object2, 'obj4 instanceof Object2');
test.isFunction(obj4.set, 'obj4.set');
test.isFunction(obj4.get, 'obj4.get');
test.isEqual(obj4.get(), 10, 'obj4.get() == 10 (initial)');
test.isEqual(obj4.set(42), 42, 'obj4.set(42) == 42');
test.isEqual(obj4.get(), 42, 'obj4.get() == 42 (after set)');

test.end();
