/*                    TESTS FOR THE SIMPLE TEST FRAMEWORK
===============================================================================
                              by Gabriele Santilli
              (C) 2012 Silent Software, Inc. All rights reserved.

This is sort of funny: the test framework testing itself.
                                                                             */
var test = require('./test'),
    Promise = require('./Promise').Promise,
    define = require('./utils').define,
    Timer = define({
        inherit: Promise,
        manualSuper: true,
        constructor: function(time, value, eventName) {
            Promise.call(this);
            var promise = this;
            setTimeout(function() {promise.emit(eventName || 'success', value);}, time);
        }
    });

test.begin('Simple test framework');

console.log("ATTENTION: we're supposed to have *exactly* 29 failed tests here.");

test(1 == 1, '1 == 1');
test(new Timer(500, 1 == 1), '1 == 1 (delayed)');
test(new Timer(1000, 1 == 1), '1 == 1 (timeout)', 500);
test(1 == 2, '1 == 2');
test(new Timer(500, 1 == 2), '1 == 2 (delayed)');
test(new Timer(1000, 1 == 2), '1 == 2 (timeout)', 500);

test.isFunction(test, 'test');
test.isFunction(new Timer(500, test), 'test (delayed)');
test.isFunction(new Timer(1000, test), 'test (timeout)', 500);
test.isFunction(42, '42');
test.isFunction(new Timer(500, 42), '42 (delayed)');
test.isFunction(new Timer(1000, 42), '42 (timeout)', 500);

test.isObject({}, '{}');
test.isObject(new Timer(500, {}), '{} (delayed)');
test.isObject(new Timer(1000, {}), '{} (timeout)', 500);
test.isObject(42, '42');
test.isObject(new Timer(500, 42), '42 (delayed)');
test.isObject(new Timer(1000, 42), '42 (timeout)', 500);

var Object1 = define({}),
    obj1 = new Object1;

test.instanceOf(obj1, Object1, 'obj1 instanceof Object1');
test.instanceOf(new Timer(500, obj1), Object1, 'obj1 instanceof Object1 (delayed)');
test.instanceOf(new Timer(1000, obj1), Object1, 'obj1 instanceof Object1 (timeout)', 500);
test.instanceOf({}, Object1, '{} instanceof Object1');
test.instanceOf(new Timer(500, {}), Object1, '{} instanceof Object1 (delayed)');
test.instanceOf(new Timer(1000, {}), Object1, '{} instanceof Object1 (timeout)', 500);

test.isEqual(1, 1, '1 == 1 (isEqual)');
test.isEqual(new Timer(500, 1), new Timer(400, 1), '1 == 1 (isEqual, delayed)');
test.isEqual(new Timer(1000, 1), new Timer(400, 1), '1 == 1 (isEqual, timeout)', 500);
test.isEqual(1, 2, '1 == 2 (isEqual)');
test.isEqual(new Timer(500, 1), new Timer(400, 2), '1 == 2 (isEqual, delayed)');
test.isEqual(new Timer(1000, 1), new Timer(400, 2), '1 == 2 (isEqual, timeout)', 500);

test.deepEqual([1, 2, 3], [1, 2, 3], '[1, 2, 3] == [1, 2, 3]');
test.deepEqual(new Timer(500, [1, 2, 3]), new Timer(400, [1, 2, 3]), '[1, 2, 3] == [1, 2, 3] (delayed)');
test.deepEqual(new Timer(1000, [1, 2, 3]), new Timer(400, [1, 2, 3]), '[1, 2, 3] == [1, 2, 3] (timeout)', 500);
test.deepEqual([1, 2, 3], [1, 2, 4], '[1, 2, 3] == [1, 2, 4]');
test.deepEqual(new Timer(500, [1, 2, 3]), new Timer(400, [1, 2, 4]), '[1, 2, 3] == [1, 2, 4] (delayed)');
test.deepEqual(new Timer(1000, [1, 2, 3]), new Timer(400, [1, 2, 4]), '[1, 2, 3] == [1, 2, 4] (timeout)', 500);

var error = new ReferenceError;

test.isError(error, ReferenceError, 'error');
test.isError(new Timer(500, error, 'error'), ReferenceError, 'error (delayed)');
test.isError(new Timer(1000, error, 'error'), ReferenceError, 'error (timeout)', 500);
test.isError(42, ReferenceError, '42');
test.isError(new Timer(500, 42), ReferenceError, '42 (delayed)');
test.isError(new Timer(1000, 42), ReferenceError, '42 (timeout)', 500);

function f() {
    throw new ReferenceError;
}
function g() {
    return true;
}

test.throws(f, ReferenceError, 'f');
test.throws(g, ReferenceError, 'g');

test.onResolution(new Timer(500, 42), function() {return 1 == 1;}, '1 == 1 (onResolution)');
test.onResolution(new Timer(500, 42), function() {return 1 == 2;}, '1 == 2 (onResolution)');

test.onResolutionThrows(new Timer(500, 42), f, ReferenceError, 'f (onResolutionThrows)');
test.onResolutionThrows(new Timer(500, 42), g, ReferenceError, 'g (onResolutionThrows)');

test.end();
