/*                  TEST FOR THE CYBERSOURCE SOAP API CLIENT
===============================================================================
                              by Gabriele Santilli
              (C) 2012 Silent Software, Inc. All rights reserved.

This program tests the [CyberSourceClient_objects] module.
                                                                             */
var test = require('./test'),
    CyberSourceClient = require('./CyberSourceClient.js').CyberSourceClient,
    fs = require('fs'),
    promisify = require('./Promise').promisify,
    config = JSON.parse(fs.readFileSync('.config', 'utf-8')).cyberSource;

test.begin('CyberSource SOAP API client');

var client = new CyberSourceClient(config);
test.isObject(client, 'client');

var subscriptionId = client.createOnDemandSubscription({
    firstName:    'John',
    lastName:     'Doe',
    street:       '1295 Charleston Road',
    city:         'Mountain View',
    state:        'CA',
    postalCode:   '94043',
    country:      'US',
    emailAddress: 'null@cybersource.com',
    ipAddress:    '10.7.111.111',
    currency:     'USD',
    creditCard:   {
        number:          '4111111111111111',
        expirationMonth: '12',
        expirationYear:  '2020',
        type:            'Visa'
    },
    title:         'On-demand profile test'
});
test.isString(subscriptionId, 'subscriptionId');

var subscriptionData = client.retrieveSubscriptionData(subscriptionId);
test.isObject(subscriptionData, 'subscriptionData');
test.isEqual(subscriptionData.getValue('creditCard', 'number'), '411111XXXXXX1111',
        'subscriptionData.creditCard.number == "411111XXXXXX1111"');

var payment = client.billSubscriber(subscriptionId, '9.95');
test.isObject(payment, 'payment');
test.isEqual(payment.getValue('amount'), '9.95', 'payment.amount == "9.95"');

var isUpdated = client.updateSubscriptionData(subscriptionId, {
    firstName:    'Homer',
    lastName:     'Simpson',
    street:       '1295 Charleston Road',
    city:         'Mountain View',
    state:        'CA',
    postalCode:   '94043',
    country:      'US',
    emailAddress: 'null@cybersource.com',
    ipAddress:    '10.7.111.112',
    creditCard:   {
        number:          '4111111111111111',
        expirationMonth: '12',
        expirationYear:  '2020',
        type:            'Visa'
    }
});
test(isUpdated, 'updateSubscriptionData()');

function checkUpdate(subscriptionId, isUpdated) {
    return client.retrieveSubscriptionData(subscriptionId);
}
checkUpdate = promisify(checkUpdate);

var newSubscriptionData = checkUpdate(subscriptionId, isUpdated);
test.isObject(newSubscriptionData, 'newSubscriptionData');
test.isEqual(newSubscriptionData.getValue('firstName'), 'HOMER', 'newSubscriptionData.firstName == "Homer"');
test.isEqual(newSubscriptionData.getValue('lastName'), 'SIMPSON', 'newSubscriptionData.lastName == "Simpson"');

function restoreData(subscriptionId, newSubscriptionData) {
    return client.updateSubscriptionData(subscriptionId, {
        firstName:    'John',
        lastName:     'Doe',
        street:       '1295 Charleston Road',
        city:         'Mountain View',
        state:        'CA',
        postalCode:   '94043',
        country:      'US',
        emailAddress: 'null@cybersource.com',
        ipAddress:    '10.7.111.111',
        currency:     'USD',
    });
}
restoreData = promisify(restoreData);

var isRestored = restoreData(subscriptionId, newSubscriptionData);
test(isRestored, 'restoreData()');

var restoredSubscriptionData = checkUpdate(subscriptionId, isRestored);
test.isObject(restoredSubscriptionData, 'restoredSubscriptionData');
test.isEqual(restoredSubscriptionData.getValue('firstName'), 'JOHN', 'restoredSubscriptionData.firstName == "John"');
test.isEqual(restoredSubscriptionData.getValue('lastName'), 'DOE', 'restoredSubscriptionData.lastName == "Doe"');
test.isEqual(restoredSubscriptionData.getValue('creditCard', 'number'), '411111XXXXXX1111',
        'restoredSubscriptionData.creditCard.number == "411111XXXXXX1111"');

test.end();
