/*                    TESTS FOR THE PROLIFIC CONFIG MODULE
===============================================================================
                              by Gabriele Santilli
              (C) 2012 Silent Software, Inc. All rights reserved.

This program tests the config module.
                                                                             */
var test = require('./test'),
    c = require('./config');

test.begin('Prolific configuration module');

var spec = {
    configFile: './config-tests1.json',
    options: {
        one: {
            type: c.String,
            help: 'First option'
        },
        two: {
            type: c.Number,
            defaultValue: 10,
            help: 'Second option'
        },
        three: {
            type: c.Boolean,
            defaultValue: true,
            help: 'Third option'
        },
        four: {
            type: new c.Object({
                num: {
                    type: c.Number
                },
                bool: {
                    type: c.Boolean
                }
            })
        },
        five: {
            type: c.Object,
            defaultValue: {}
        },
        six: {
            type: new c.ArrayOf(new c.Object({
                num: {
                    type: c.Number
                },
                bool: {
                    type: c.Boolean,
                    defaultValue: true
                }
            }))
        }
    },
    shortHands: {
        seven: ["--one", "Seven used", "--no-three"]
    }
};

process.argv = [1, 2];
var obj = c(spec);
test.isEqual(obj.one, 'Test1', 'config1.one');
test.isEqual(obj.two, 10, 'config1.two');
test.isEqual(obj.three, false, 'config1.three');
test.isObject(obj.four, 'config1.four');
test.isEqual(obj.four.num, 1, 'config1.four.num');
test.isEqual(obj.four.bool, false, 'config1.four.bool');
test.isObject(obj.five, 'config1.five');
test.isArray(obj.six, 'config1.six');
test.isObject(obj.six[0], 'config1.six[0]');
test.isEqual(obj.six[0].num, 1, 'config1.six[0].num');
test.isEqual(obj.six[0].bool, true, 'config1.six[0].bool');

process.argv = [1, 2, '--config', 'config-tests2.json'];
test.throws(function() {c(spec);}, Error, 'c(... --config config-tests2.json)');

process.argv = [1, 2, '--one', 'Test3', '--two', '42'];
var obj = c(spec);
test.isEqual(obj.one, 'Test3', 'config3.one');
test.isEqual(obj.two, 42, 'config3.two');
test.isEqual(obj.three, false, 'config3.three');
test.isObject(obj.four, 'config3.four');
test.isEqual(obj.four.num, 1, 'config3.four.num');
test.isEqual(obj.four.bool, false, 'config3.four.bool');
test.isObject(obj.five, 'config3.five');
test.isArray(obj.six, 'config3.six');
test.isObject(obj.six[0], 'config3.six[0]');
test.isEqual(obj.six[0].num, 1, 'config3.six[0].num');
test.isEqual(obj.six[0].bool, true, 'config3.six[0].bool');

process.argv = [1, 2, '--seven'];
var obj = c(spec);
test.isEqual(obj.one, 'Seven used', 'config4.one');
test.isEqual(obj.two, 10, 'config4.two');
test.isEqual(obj.three, false, 'config4.three');
test.isObject(obj.four, 'config4.four');
test.isEqual(obj.four.num, 1, 'config4.four.num');
test.isEqual(obj.four.bool, false, 'config4.four.bool');
test.isObject(obj.five, 'config4.five');
test.isArray(obj.six, 'config4.six');
test.isObject(obj.six[0], 'config4.six[0]');
test.isEqual(obj.six[0].num, 1, 'config4.six[0].num');
test.isEqual(obj.six[0].bool, true, 'config4.six[0].bool');

process.argv = [1, 2];
var obj = c(spec, require('./syslog').configSpec);
test.isEqual(obj.one, 'Test1', 'config5.one');
test.isEqual(obj.two, 10, 'config5.two');
test.isEqual(obj.three, false, 'config5.three');
test.isObject(obj.four, 'config5.four');
test.isEqual(obj.four.num, 1, 'config5.four.num');
test.isEqual(obj.four.bool, false, 'config5.four.bool');
test.isObject(obj.five, 'config5.five');
test.isArray(obj.six, 'config5.six');
test.isObject(obj.six[0], 'config5.six[0]');
test.isEqual(obj.six[0].num, 1, 'config5.six[0].num');
test.isEqual(obj.six[0].bool, true, 'config5.six[0].bool');
test.isEqual(obj.logLevel, 'warning', 'config5.logLevel');
test.isEqual(obj.logIdentity, 'node', 'config5.logIdentity');
test.isEqual(obj.logFacility, 'daemon', 'config5.logFacility');

test.end();
